# HR Payroll Test Dataset

This test dataset contains realistic multi-source employee and payroll data from different HR systems. It's designed to help you test Datally's powerful data consolidation capabilities.

## What's Included

This dataset contains 4 CSV files representing data from different HR and payroll systems:

### 1. **DICTIONARY_workday_export.csv**
- **Purpose**: Reference schema/dictionary from Workday
- **Description**: This file serves as your target schema - the standardized format you want to consolidate your data into
- **Use in Datally**: Upload this as your **Reference File** to define the target column structure

### 2. **adp_workforce.csv**
- **Purpose**: Employee records from ADP Workforce Now
- **Description**: Contains employee data with ADP-specific column names and formatting
- **Use in Datally**: Upload as a **Source File** to map and consolidate

### 3. **bamboohr_employees.csv**
- **Purpose**: HR data from BambooHR platform
- **Description**: Employee information with BambooHR's naming conventions
- **Use in Datally**: Upload as a **Source File** to map and consolidate

### 4. **paychex_roster.csv**
- **Purpose**: Payroll data from Paychex
- **Description**: Employee roster with Paychex-specific fields
- **Use in Datally**: Upload as a **Source File** to map and consolidate

## How to Use This Dataset in Datally

### Step 1: Create a New Session
1. Launch Datally
2. Click "New Session" or "Create Session"
3. Give your session a name (e.g., "HR Payroll Test")

### Step 2: Upload Reference File
1. In the Upload stage, upload **DICTIONARY_workday_export.csv** as your Reference File
2. This defines the target schema you want to consolidate into

### Step 3: Upload Source Files
1. Upload the three source files:
   - adp_workforce.csv
   - bamboohr_employees.csv
   - paychex_roster.csv
2. These represent the different data sources you want to consolidate

### Step 4: Analyze
1. Click "Analyze" to let Datally examine your data
2. Review the data quality metrics and column statistics

### Step 5: Map Columns
1. Use Datally's intelligent mapping to match source columns to reference columns
2. Try the AI-powered suggestions for quick mapping
3. Handle any unmapped or conflicting columns

### Step 6: Validate
1. Set up validation rules to ensure data quality
2. Test rules like:
   - Required fields (e.g., Employee ID must be present)
   - Format validation (e.g., email addresses, phone numbers)
   - Value ranges (e.g., salary ranges, date ranges)

### Step 7: Consolidate
1. Run the consolidation to merge all sources into a single unified dataset
2. Download the consolidated file in your preferred format (CSV or Excel)

## Common Data Challenges This Dataset Demonstrates

This test dataset includes realistic data quality challenges you'll encounter in real-world scenarios:

- **Inconsistent Column Names**: Each system uses different names for the same data (e.g., "emp_id" vs "employee_number" vs "EmpID")
- **Different Date Formats**: Various date formatting across systems
- **Missing Values**: Some records have incomplete data
- **Data Type Variations**: Numbers stored as text, inconsistent formatting
- **Duplicate Records**: Potential overlapping employee records across systems
- **Case Sensitivity**: Inconsistent capitalization in names and values

## Tips for Testing

1. **Start Simple**: Begin by mapping just a few key columns to understand the workflow
2. **Use AI Suggestions**: Let Datally's AI recommend mappings to save time
3. **Test Validation Rules**: Create rules to catch data quality issues
4. **Experiment with Translations**: Try value translations for standardizing codes or categories
5. **Export and Review**: Download the consolidated file and verify the results

## Support

If you have questions or need help:
- Email: support@datally.io
- Visit: https://datally.io

## License

This test dataset is provided for evaluation and testing purposes only. The data is synthetic and does not represent real individuals or organizations.

---

**Happy Testing!** 🚀

We hope this dataset helps you experience the power of Datally's intelligent data consolidation platform.

